% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_exposure.R
\name{exposure}
\alias{exposure}
\title{MD-PMS Exposure Data Frame}
\usage{
exposure(data_frame, time, device_hierarchy, event_hierarchy = NULL,
  key = NULL, match_levels = NULL, count = NULL)
}
\arguments{
\item{data_frame}{The input data frame requiring components specified in the
remaining arguments.}

\item{time}{Character name of date variable in \code{data_frame}. Class must
be Date, POSIXt, or character.

Example: \code{"event_date"}}

\item{device_hierarchy}{Vector of character variable names representing the
device hierarchy in \code{data_frame}. Vector ordering is lowest level first,
most general level last.

Example: \code{c("Version", "Device", "ProductLine")}}

\item{event_hierarchy}{Vector of character variable names representing the
event hierarchy in \code{data_frame}. Vector ordering is most specific event
category first, most broad event category last.

Example: \code{c("Family", "Device", "ProductCode")}

Default: \code{NULL} will not include any event hierarchy.}

\item{key}{Character name of (uniquely identifying) primary key variable in
\code{data_frame}. Class must be character or numeric.

Example: \code{"key_ID"}

Default: \code{NULL} will create a key variable.}

\item{match_levels}{Vector of character variable names in \code{data_frame}
representing additional grouping factors for exposure. Specified variables
will be implicitly matched to equivalently named variables contained in the
\code{mds_de} object class.

Example: \code{c("Country", "Region")}

Default: \code{NULL} will not include any additional grouping factors.}

\item{count}{Character name of exposure count variable in \code{data_frame}.
Class must be numeric.

Example: \code{"Units Sold"}

Default: \code{NULL} will assume each row represents one exposure.}
}
\value{
A standardized MD-PMS data frame of class \code{mds_e}.
Rows are deduplicated. Attributes are as follows:
\describe{
  \item{key}{Original variable name for \code{key}}
  \item{time}{Original variable name for \code{time}}
  \item{device_hierarchy}{Vector of original variable names for
  \code{device_hierarchy} with converted variable names correspondingly
  named.}
  \item{event_hierarchy}{Vector of original variable names for
  \code{event_hierarchy} with converted variable names correspondingly
  named.}
  \item{match_levels}{Vector of variable names for grouping factors}
  \item{count}{Original variable name for \code{count}}
}
}
\description{
Converts a data frame into a MD-PMS Exposure data frame.
}
\examples{
# A barebones dataset
ex <- exposure(sales, "sales_month", "device_name")
# With more variables and variable types
ex <- exposure(
  data_frame=sales,
  time="sales_month",
  device_hierarchy="device_name",
  match_levels="region",
  count="sales_volume")

}
