/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.util.LinkedList;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.Coordinates;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.figures.Band;
import multidendrograms.dendrogram.figures.Line;
import multidendrograms.dendrogram.figures.Node;
import multidendrograms.initial.Language;
import multidendrograms.initial.LogManager;
import multidendrograms.types.OriginType;
import multidendrograms.types.ProximityType;

public class DendrogramPlot {
    private static ProximityType proximityType;
    private final int precision;
    private final double radius;
    private final boolean bandVisible;
    private final OriginType originType;
    private final double dendroBottomHeight;
    private int next = 0;
    private final LinkedList<Node> nodesList = new LinkedList();
    private final LinkedList<Line> linesList = new LinkedList();
    private final LinkedList<Band> bandsList = new LinkedList();

    public DendrogramPlot(Dendrogram dendrogram, Config config) throws Exception {
        proximityType = config.getProximityType();
        this.precision = config.getPrecision();
        this.radius = config.getRadius();
        SettingsInfo settingsInfo = config.getSettingsInfo();
        this.bandVisible = settingsInfo.isBandVisible();
        this.originType = settingsInfo.getOriginType();
        this.dendroBottomHeight = proximityType.equals((Object)ProximityType.DISTANCE) ? config.getAxisMinValue() : config.getAxisMaxValue();
        this.branchNodeCoordinates(dendrogram);
    }

    private Coordinates<Double> branchNodeCoordinates(Dendrogram dendrogram) throws Exception {
        Coordinates<Double> coordinates = new Coordinates<Double>(0.0, 0.0);
        double d = dendrogram.getRootBottomHeight();
        double d2 = dendrogram.getRootTopHeight();
        int n = dendrogram.numberOfSubclusters();
        if (n == 1) {
            ++this.next;
            double d3 = this.radius * (double)(3 * this.next - 1);
            coordinates.setX(d3);
            if (Double.isNaN(d) || this.originType.equals((Object)OriginType.UNIFORM_ORIGIN)) {
                coordinates.setY(this.dendroBottomHeight);
            } else {
                double d4 = proximityType.equals((Object)ProximityType.DISTANCE) ? Math.max(d, this.dendroBottomHeight) : Math.min(d, this.dendroBottomHeight);
                coordinates.setY(d4);
            }
            this.nodesList.add(new Node(coordinates.getX(), coordinates.getY(), this.radius, dendrogram.getLabel()));
        } else {
            d2 = MathUtils.round(d2, this.precision);
            d = MathUtils.round(d, this.precision);
            double d5 = this.bandVisible ? Math.abs(d2 - d) : 0.0;
            d5 = MathUtils.round(d5, this.precision);
            double d6 = Double.MAX_VALUE;
            double d7 = Double.MIN_VALUE;
            for (int i = 0; i < n; ++i) {
                try {
                    coordinates = this.branchNodeCoordinates(dendrogram.getSubcluster(i));
                }
                catch (Exception exception) {
                    String string = Language.getLabel(64) + "\n" + exception.getMessage();
                    LogManager.LOG.throwing(string, "Branch(final Cluster c)", exception);
                    throw new Exception(string);
                }
                double d8 = coordinates.getX();
                double d9 = MathUtils.round(coordinates.getY(), this.precision);
                d6 = Math.min(d6, d8);
                d7 = Math.max(d7, d8);
                this.linesList.add(new Line(d8, d9, d));
                LogManager.LOG.finer("new Line: (" + d8 + ", " + d9 + ", " + d + ", " + this.precision + ")");
            }
            coordinates.setX((d6 + d7) / 2.0);
            if (this.bandVisible) {
                coordinates.setY(d2);
            } else {
                coordinates.setY(d);
            }
            this.bandsList.add(new Band(d6, d, d5, d7 - d6));
            LogManager.LOG.finer("Band: (" + d6 + ", " + d + ", " + d5 + ", " + (d7 - d6));
        }
        return coordinates;
    }

    public LinkedList<Node> getNodesList() {
        return this.nodesList;
    }

    public LinkedList<Line> getLinesList() {
        return this.linesList;
    }

    public LinkedList<Band> getBandsList() {
        return this.bandsList;
    }
}

