% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regmodel.R
\name{plotRMSE.regmodel}
\alias{plotRMSE.regmodel}
\title{RMSE plot for regression model}
\usage{
\method{plotRMSE}{regmodel}(
  obj,
  ny = 1,
  type = "b",
  labels = "values",
  xticks = seq_len(obj$ncomp),
  res = obj$res,
  ...
)
}
\arguments{
\item{obj}{a regression model (object of class \code{regmodel})}

\item{ny}{number of response variable to make the plot for (if y is multivariate)}

\item{type}{type of the plot("b", "l" or "h")}

\item{labels}{what to show as labels (vector or name, e.g. "names", "values", "indices")}

\item{xticks}{vector with ticks for x-axis values}

\item{res}{list with result objects}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows plot with root mean squared error values vs. number of components for PLS model.
}
