% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_methods.R
\name{show,SampleSize-method}
\alias{show,SampleSize-method}
\alias{show}
\alias{show,MCTab-method}
\alias{show,BAsummary-method}
\alias{show,RefInt-method}
\alias{show,tpROC-method}
\title{Show Method for Objects}
\usage{
\S4method{show}{SampleSize}(object)

\S4method{show}{MCTab}(object)

\S4method{show}{BAsummary}(object)

\S4method{show}{RefInt}(object)

\S4method{show}{tpROC}(object)
}
\arguments{
\item{object}{(\code{any})\cr input.}
}
\value{
None (invisible \code{NULL}), only used for the side effect of printing to
the console.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A show method that displays essential information of objects.
}
\examples{
# Sample zie calculation
size_one_prop(p1 = 0.95, p0 = 0.9, alpha = 0.05, power = 0.8)
size_ci_corr(r = 0.9, lr = 0.85, alpha = 0.025, alternative = "greater")

# Get 2x2 Contingency Table
qualData \%>\% diagTab(formula = ~ CandidateN + ComparativeN)

# Bland-Altman analysis
data("platelet")
blandAltman(x = platelet$Comparative, y = platelet$Candidate)

# Reference Interval
data("calcium")
refInterval(x = calcium$Value, RI_method = "nonparametric", CI_method = "nonparametric")

# Comparing the Paired ROC when Non-inferiority margin <= -0.1
data("ldlroc")
aucTest(
  x = ldlroc$LDL, y = ldlroc$OxLDL, response = ldlroc$Diagnosis,
  method = "non-inferiority", h0 = -0.1
)
}
