% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_jags.R
\name{get_jags_data}
\alias{get_jags_data}
\title{Adds helper variables for use in \code{run_jags}}
\usage{
get_jags_data(data, ST, jags_code, sample)
}
\arguments{
\item{data}{A tibble}

\item{ST}{A segment table (tibble), returned by \code{get_segment_table}.}

\item{jags_code}{A string. JAGS model, usually returned by \code{make_jagscode()}.}

\item{sample}{One of
\itemize{
\item \code{"post"}: Sample the posterior.
\item \code{"prior"}: Sample only the prior. Plots, summaries, etc. will
use the prior. This is useful for prior predictive checks.
\item \code{"both"}: Sample both prior and posterior. Plots, summaries, etc.
will default to using the posterior. The prior only has effect when doing
Savage-Dickey density ratios in \code{\link{hypothesis}}.
\item \code{"none"} or \code{FALSE}: Do not sample. Returns an mcpfit
object without sample. This is useful if you only want to check
prior strings (fit$prior), the JAGS model (fit$jags_code), etc.
}}
}
\description{
Returns the relevant data columns as a list and add elements with unique
varying group levels.
}
\keyword{internal}
