% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_reg.R
\name{reg}
\alias{reg}
\title{Create a model component object for a regression (fixed effects) component
in the linear predictor}
\usage{
reg(
  formula = ~1,
  remove.redundant = FALSE,
  sparse = NULL,
  X = NULL,
  prior = NULL,
  Q0 = NULL,
  b0 = NULL,
  R = NULL,
  r = NULL,
  S = NULL,
  s = NULL,
  lower = NULL,
  upper = NULL,
  name = "",
  debug = FALSE
)
}
\arguments{
\item{formula}{a formula specifying the predictors to be used in the model,
in the same way as the right hand side of the \code{formula} argument of
R's \code{lm} function. Variable names are looked up in the data frame
passed as \code{data} argument to \code{\link{create_sampler}} or
\code{\link{generate_data}}, or in \code{environment(formula)}.}

\item{remove.redundant}{whether redundant columns should be removed from the
design matrix. Default is \code{FALSE}. But note that treatment contrasts are
automatically applied to all factor variables in \code{formula}.}

\item{sparse}{whether the model matrix associated with \code{formula} should
be sparse. The default is to base this on a simple heuristic.}

\item{X}{a (possibly sparse) design matrix can be specified directly, as an
alternative to the creation of one based on \code{formula}. If \code{X} is
specified \code{formula} is ignored.}

\item{prior}{prior specification for the regression coefficients. Supported
priors can be specified using functions \code{\link{pr_normal}},
\code{\link{pr_fixed}}, or \code{\link{pr_MLiG}}. The latter prior is only
available in conjunction with a gamma family sampling distribution.}

\item{Q0}{prior precision matrix for the regression effects. The default is a
zero matrix corresponding to a noninformative improper prior.
It can be specified as a scalar value, as a numeric vector of appropriate
length, or as a matrix object. DEPRECATED, please use argument \code{prior}
instead, i.e. \code{prior = pr_normal(mean = b0.value, precision = Q0.value)}.}

\item{b0}{prior mean for the regression effect. Defaults to a zero vector.
It can be specified as a scalar value or as a numeric vector of
appropriate length. DEPRECATED, please use argument \code{prior}
instead, i.e. \code{prior = pr_normal(mean = b0.value, precision = Q0.value)}.}

\item{R}{optional constraint matrix for equality restrictions R'x = r where
\code{x} is the vector of regression effects.}

\item{r}{right hand side for the equality constraints.}

\item{S}{optional constraint matrix for inequality constraints S'x >= s where
\code{x} is the vector of regression effects.}

\item{s}{right hand side for the inequality constraints.}

\item{lower}{as an alternative to \code{s}, \code{lower} and \code{upper} may be specified
for two-sided constraints lower <= S'x <= upper.}

\item{upper}{as an alternative to \code{s}, \code{lower} and \code{upper} may be specified
for two-sided constraints lower <= S'x <= upper.}

\item{name}{the name of the model component. This name is used in the output of the
MCMC simulation function \code{\link{MCMCsim}}. By default the name will be 'reg'
with the number of the model term attached.}

\item{debug}{if \code{TRUE} a breakpoint is set at the beginning of the posterior
draw function associated with this model component. Mainly intended for developers.}
}
\value{
an object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component. Intended
 for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the
\code{formula} argument to \code{\link{create_sampler}} or
\code{\link{generate_data}}. It creates an additive regression term in the
model's linear predictor. By default, the prior for the regression
coefficients is improper uniform. A proper normal prior can be set up
using function \code{\link{pr_normal}}, and passed to argument \code{prior}.
It should be noted that \code{\link{pr_normal}} expects a precision matrix
as input for its second argument, and that the prior variance (matrix) is
taken to be the inverse of this precision matrix, where in case the
model's family is \code{"gaussian"} this matrix is additionally
multiplied by the residual scalar variance parameter \code{sigma_^2}.
}
\examples{
\donttest{
data(iris)
# default: flat priors on regression coefficients
sampler <- create_sampler(Sepal.Length ~
    reg(~ Petal.Length + Species, name="beta"),
  data=iris
)
sim <- MCMCsim(sampler, burnin=100, n.iter=400)
summary(sim)
# (weakly) informative normal priors on regression coefficients
sampler <- create_sampler(Sepal.Length ~
    reg(~ Petal.Length + Species, prior=pr_normal(precision=1e-2), name="beta"),
  data=iris
)
sim <- MCMCsim(sampler, burnin=100, n.iter=400)
summary(sim)
# binary regression
sampler <- create_sampler(Species == "setosa" ~
    reg(~ Sepal.Length, prior=pr_normal(precision=0.1), name="beta"),
  family="binomial", data=iris)
sim <- MCMCsim(sampler, burnin=100, n.iter=400)
summary(sim)
pred <- predict(sim)
str(pred)
# example with equality constrained regression effects
n <- 500
df <- data.frame(x=runif(n))
df$y <- rnorm(n, 1 + 2*df$x)
R <- matrix(1, 2, 1)
r <- 3
sampler <- create_sampler(y ~ reg(~ 1 + x, R=R, r=r, name="beta"), data=df)
sim <- MCMCsim(sampler)
summary(sim)
plot(sim, "beta")
summary(transform_dc(sim$beta, fun=function(x) crossprod_mv(R, x) - r))
}

}
