% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjugate_gradients.R
\name{setup_CG_sampler}
\alias{setup_CG_sampler}
\title{Set up conjugate gradient sampler}
\usage{
setup_CG_sampler(
  mbs,
  X,
  sampler,
  max.it = NULL,
  stop.criterion = NULL,
  verbose = NULL,
  preconditioner = c("GMRF", "GMRF2", "GMRF3", "identity"),
  scale
)
}
\arguments{
\item{mbs}{block component containing several model components.}

\item{X}{design matrix.}

\item{sampler}{sampler object as created by \code{\link{create_sampler}}.}

\item{max.it}{passed to \code{\link{CG}}.}

\item{stop.criterion}{passed to \code{\link{CG}}.}

\item{verbose}{passed to \code{\link{CG}}.}

\item{preconditioner}{one of  "GMRF", "GMRF2", "GMRF3" and "identity".}

\item{scale}{scale parameter for GMRF3 preconditioner.}
}
\value{
An environment with precomputed quantities and functions for multiplication
  by A and by an (inverse) preconditioning matrix.
}
\description{
Set up conjugate gradient sampler
}
\references{
A. Nishimura and M.A. Suchard (2018).
   Prior-preconditioned conjugate gradient method for accelerated Gibbs sampling in
   large n & large p sparse Bayesian regression.
   arXiv:1810.12437.
}
\keyword{internal}
