% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.R
\name{mcmcsae-family}
\alias{mcmcsae-family}
\alias{f_gaussian}
\alias{f_binomial}
\alias{f_negbinomial}
\alias{f_poisson}
\alias{f_multinomial}
\title{Functions for specifying a sampling distribution and link function}
\usage{
f_gaussian(link = "identity")

f_binomial(link = c("logit", "probit"))

f_negbinomial(link = "logit")

f_poisson(link = "log")

f_multinomial(link = "logit", K = NULL)
}
\arguments{
\item{link}{the name of a link function. Currently the only allowed link functions are:
\code{"identity"} for (log-)Gaussian sampling distributions, \code{"logit"} (default) and \code{"probit"}
for binomial distributions and \code{"log"} for negative binomial sampling distributions.}

\item{K}{number of categories for multinomial model; this must be specified for prior predictive sampling.}
}
\value{
A family object.
}
\description{
These functions are intended for use in the \code{family} argument of \code{\link{create_sampler}}.
In future versions these functions may gain additional arguments, but currently the corresponding
functions \code{gaussian} and \code{binomial} can be used as well.
}
