% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_twin.R
\name{mc_twin}
\alias{mc_twin}
\alias{mc_twin_bio}
\alias{mc_twin_full}
\title{Twin Models Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_twin(id, twin.id, type, replicate = NULL, structure, data)

mc_twin_bio(id, twin.id, type, replicate = NULL, structure, data)

mc_twin_full(id, twin.id, type, replicate, formula, data)
}
\arguments{
\item{id}{name of the column (string) containing the twin index.
It should be the same index (number) for both twins.}

\item{twin.id}{name of the column (string) containing the twin index
inside the pair. In general 1 for the first twin and 2 for the second
twin.}

\item{type}{name of the column (string) containing the indication of
the twin as mz or dz. It should be a factor with only two levels mz and dz.
Be sure that the reference level is mz.}

\item{replicate}{name of the column (string) containing the index
for more than one observation taken at the same twin pair. It is used
for example in twin longitudinal studies. In that case, the replication
column should contain the time index.}

\item{structure}{model type options are full, flex, uns, ACE, ADE,
AE, CE and E. See example for details.}

\item{data}{data set.}

\item{formula}{internal.}
}
\value{
A list of matrices of \code{dgCMatrix} class.
}
\description{
The function \code{mc_twin} helps to build the components
of the matrix linear predictor associated with ACDE models for
analysis of twin data.
}
\examples{
id <- rep(1:5, each = 4)
id.twin <- rep(1:2, 10)
}
\seealso{
\code{mc_id}, \code{mc_dist}, \code{mc_car},
\code{mc_rw}, \code{mc_ns}, \code{mc_dglm} and \code{mc_mixed}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
