% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaghetti.R
\name{spaghetti}
\alias{spaghetti}
\alias{spaghetti.mc}
\alias{spaghetti.mcnode}
\title{Spaghetti Plot of mc/mcnode Object}
\usage{
spaghetti(x, ...)

\method{spaghetti}{mc}(
  x,
  griddim = NULL,
  xlab = names(x),
  ylab = "F(n)",
  main = "",
  maxlines = 100,
  ...
)

\method{spaghetti}{mcnode}(x, ...)
}
\arguments{
\item{x}{mc/mcnode object}

\item{...}{further arguments to be passed to plot.stepfun()}

\item{griddim}{a vector of two integers, indicating the size of the grid of the graph. If NULL, the grid is calculated to produce a "nice" graph.}

\item{xlab}{vector of labels for the x-axis. If NULL, use the name of the node.}

\item{ylab}{vector of labels for the y-axis.}

\item{main}{vector of main titles of the graph.}

\item{maxlines}{the maximum number of ecdf to draw.}
}
\description{
Use plot to draw spaghetti plots for the mc/mcnode objects.
}
\examples{
data(total)
spaghetti(mc(xVUM))
spaghetti(xVUM)

}
