% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxlinalg.R
\name{maxmatmul}
\alias{maxmatmul}
\title{Multiply two matrices with a matrix product that uses maxima instead of addition}
\usage{
maxmatmul(A, B)
}
\arguments{
\item{A}{a non-negative array of dim n, k}

\item{B}{a non-negative array of dim k, l}
}
\value{
A non netgative array of dim n, l.
The entries are given by the maximum of componentwise multiplication
of rows from A and columns from B.
}
\description{
By calculating the entries with
\deqn{(A \diamond B)_{ij} = \max_{j=1,..., l} A_{il} B_{lj}}
for appropriate dimensions. Note that this operation is particularly
useful when working with multivariate exreme value distributions,
because, if the margins are standardized to standard Fréchet margins,
then the max-matrix product of a matrix A and a multivariate extreme value
distribution Z with standard Fréchet margins has the same margins up
to scaling.
}
\examples{
# Set up example matrices
A <- matrix(c(1,2,3,4,5,6), 2, 3)
B <- matrix(c(1,2,1,2,1,2), 3, 2)

# calling the function 
m1 <- maxmatmul(A, B)

# can be used for matrix-vector multiplication as well
v <- c(7,4,7)
m2 <- maxmatmul(A, v)
m3 <- maxmatmul(v,v)
}
