% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matsindf_apply.R
\name{matsindf_apply_types}
\alias{matsindf_apply_types}
\title{Determine types of \code{...} argument for matsindf_apply}
\usage{
matsindf_apply_types(...)
}
\arguments{
\item{...}{the list of arguments to be checked}
}
\value{
A logical list with components named \code{dots_present},
\code{all_dot_num}, \code{all_dots_mats},
\code{all_dots_list}, and \code{all_dots_char}.
}
\description{
This is a convenience function that returns a logical list for the types of \code{...}
with components named \code{dots_present}, \code{all_dots_num}, \code{all_dots_mats},
\code{all_dots_list}, \verb{all_dots_vect``, and }all_dots_char`.
}
\details{
When arguments are present in \code{...}, \code{dots_present} is \code{TRUE} but \code{FALSE} otherwise.
When all items in \code{...} are single numbers, \code{all_dots_num} is \code{TRUE} and all other list members are \code{FALSE}.
When all items in \code{...} are matrices, \code{all_dots_mats} is \code{TRUE} and all other list members are \code{FALSE}.
When all items in \code{...} are lists, \code{all_dots_list} is \code{TRUE} and all other list members are \code{FALSE}.
When all items in \code{...} are vectors (including lists), \code{all_dots_vect} is \code{TRUE}.
When all items in \code{...} are character strings, \code{all_dots_char} is \code{TRUE} and all other list members are \code{FALSE}.
}
\examples{
matsindf_apply_types(a = 1, b = 2)
matsindf_apply_types(a = matrix(c(1, 2)), b = matrix(c(2, 3)))
matsindf_apply_types(a = c(1, 2), b = c(3, 4), c = c(5, 6))
matsindf_apply_types(a = list(1, 2), b = list(3, 4), c = list(5, 6))
matsindf_apply_types(a = "a", b = "b", c = "c")
}
