% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{selectzerorows_byname}
\alias{selectzerorows_byname}
\title{Select zero rows}
\usage{
selectzerorows_byname(a, tol = 1e-06)
}
\arguments{
\item{a}{A matrix or a list of matrices.}

\item{tol}{The allowable deviation from 0 for any element.}
}
\value{
\code{a} with only zero rows selected.
}
\description{
Matrices with rows containing all zeroes are not invertible (singular).
To diagnose this problem, it is useful to find the zero rows
of a singular matrix.
This function selects (extracts) only the zero rows of a matrix.
}
\details{
A row is said to be a zero row if all elements are within \code{tol} of zero.
}
\examples{
m <- matrix(c(0, 0, 1,
              0, 0, 0), 
            dimnames = list(c("r1", "r2"), c("c1", "c2", "c3")), 
            nrow = 2, ncol = 3, byrow = TRUE) \%>\% 
  setrowtype("rows") \%>\% setcoltype("cols")
m
selectzerorows_byname(m)
}
