% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{rowtype}
\alias{rowtype}
\title{Row type}
\usage{
rowtype(a)
}
\arguments{
\item{a}{The object from which you want to extract row types.}
}
\value{
The row type of \code{a}.
}
\description{
Extracts row type of \code{a}.
}
\examples{
library(dplyr)
commoditynames <- c("c1", "c2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(commoditynames, industrynames)) \%>\%
  setrowtype(rowtype = "Commodities") \%>\% setcoltype("Industries")
rowtype(U)
# This also works for lists
rowtype(list(U,U))
}
