% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{rename_to_piece_byname}
\alias{rename_to_piece_byname}
\title{Rename matrix rows and columns by piece of row or column names}
\usage{
rename_to_piece_byname(
  a,
  piece,
  margin = c(1, 2),
  notation = RCLabels::bracket_notation,
  prepositions = RCLabels::prepositions
)
}
\arguments{
\item{a}{A matrix or list of matrices whose rows or columns will be renamed.}

\item{piece}{A character string indicating which piece of the row or column names to retain,
one of "noun", "pps", "pref" or "suff", or a preposition,
indicating which part of the row or column name is to be retained.}

\item{margin}{As a character, the row type or column type to be renamed.
As an integer, the margin to be renamed.
Default is \code{c(1, 2)}, meaning that both
rows (\code{margin = 1}) and columns (\code{margin = 2})
will be renamed.}

\item{notation}{The notation used for row and column labels.
Default is \code{RCLabels::bracket_notation}.
See \code{RCLabels}.}

\item{prepositions}{Prepositions that can be used in the row and column label.
Default is \code{RCLabels::prepositions}.}
}
\value{
A version of \code{a} with renamed rows and columns.
}
\description{
It can be convenient to rename rows or columns of matrices
based on retaining only a piece of the row and/or column names.
This function provides that capability.
}
\details{
Internally, this function finds pieces of row and column names
via the \code{RCLabels} package.
\code{piece} can be anything that \code{RCLabels::get_piece()} understands.
Note that \code{margin} can be either an integer vector or
a character vector.
If \code{margin} is a character vector,
it is interpreted as a row or column type, and
\code{margin_from_types_byname()} is called internally to
resolve the integer margins of interest.

Note that if row and/or column type are present,
the row and/or column type are also renamed according to \code{piece}.
}
\examples{
m <- matrix(c(1, 2, 
              3, 4, 
              5, 6), nrow = 3, byrow = TRUE, 
            dimnames = list(c("a -> b", "r2", "r3"), c("a -> b", "c -> d")))
m
rename_to_piece_byname(m, piece = "pref", notation = RCLabels::arrow_notation)
m2 <- m \%>\%
  setrowtype("rows") \%>\% setcoltype("cols")
m2
rename_to_piece_byname(m2, piece = "pref", margin = "rows",
                       notation = RCLabels::arrow_notation)
rename_to_piece_byname(m2, piece = "suff", margin = "rows",
                       notation = RCLabels::arrow_notation)
}
