% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.R
\name{sparse_pairwise}
\alias{sparse_pairwise}
\title{Compute similarity between pairs of rows of a matrix}
\usage{
sparse_pairwise(X, id1, id2, pairwise_function, use_furrr = FALSE)
}
\arguments{
\item{X}{matrix}

\item{id1}{vector of integers specifying the list of rows of \code{X}
(first set)}

\item{id2}{vector of integers specifying the list of rows of \code{X},
(second set), same length as \code{id1}.}

\item{pairwise_function}{function that takes a matrix and a pair of indices
specifying rows of the matrix, and computes an operation of each pair of
rows}

\item{use_furrr}{boolean indicating whether to use the furrr library
for parallel processing.}
}
\value{
data.frame with the same number of rows as the length of \code{id1}
(and \code{id2}) containing the similarity between the pairs of rows
of \code{X}. \code{sim[i] == pairwise_function(X[id1[i], ], X[id2[i], ])}.
}
\description{
\code{sparse_pairwise} computes similarity between pairs of rows of a
matrix.
}
