% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_read-write.R
\name{sim_write}
\alias{sim_write}
\title{Write similarity matrix.}
\usage{
sim_write(sim_df, output, file_format = "parquet")
}
\arguments{
\item{sim_df}{\code{metric_sim} object.}

\item{output}{character string specifying the output directory or filename.}

\item{file_format}{character string specify file format. This must be one of \code{csv} or \code{parquet}(default).}
}
\value{
No return value, called for side effects
}
\description{
\code{sim_write} writes similarity matrix.
}
\details{
The output format can be either CSV or Parquet.

With the CSV format, the \code{row_metadata} and \code{metric_metadata}
attributes are saved as separate files.

This is not required for Parquet because it saves the attributes as well.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), 4, replace = TRUE),
  x = rnorm(4),
  y = x + rnorm(4) / 100,
  z = y + rnorm(4) / 1000
)
tmpdir <- tempdir()
tmpfile_prefix <- file.path(tmpdir, "test")
sim_df <- matric::sim_calculate(population, method = "pearson")
sim_df \%>\% matric::sim_write(tmpfile_prefix, file_format = "csv")
readr::read_csv(file.path(tmpfile_prefix, "test.csv"))
readr::read_csv(file.path(tmpfile_prefix, "test_metadata.csv"))
jsonlite::read_json(file.path(tmpfile_prefix, "test_metadata.json"))
sim_df \%>\% matric::sim_write(paste0(tmpfile_prefix, ".parquet"))
sim_df_in <- arrow::read_parquet(paste0(tmpfile_prefix, ".parquet"))
attr(sim_df_in, "row_metadata")
attr(sim_df_in, "metric_metadata")
}
