% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{methods}
\name{show,ABCXYZData-method}
\alias{show,ABCXYZData-method}
\title{Shows an ABCXYZData object}
\usage{
\S4method{show}{ABCXYZData}(object)
}
\arguments{
\item{object}{The \code{ABCXYZData} object}
}
\description{
Shows the \code{ABCXYZData} object as a table consisting of the absolute and relative amount of each item,
the cumulative relative amount and the ABC-class. If XY and YZ parameters have been specified for
computing the ABCXYZData object, the table also includes a column for the XYZ coefficient, the XYZ-
class and the ABC/XYZ-class.
}
\examples{
data("Amount")
abcResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date")
abcResult
}
\seealso{
\code{\link[=ABCXYZData-class]{ABCXYZData}} \code{\link{computeABCXYZAnalysis}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
