% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{class}
\name{ABCXYZComparison-class}
\alias{ABCXYZComparison-class}
\title{Class \code{ABCXYZComparison}}
\description{
This S4 class represents the result of a comparison of two ABC/XYZ analysis results.
}
\section{Slots}{

\describe{
\item{\code{data}}{(data.frame) The comparison result as data.frame.}

\item{\code{valueDiff}}{(numeric) The difference between the value of an item in ABC/XYZ analysis A and the value of the same item
in ABC/XYZ analysis B that is required to consider the item in the comparison.}

\item{\code{xyzCoefficientDiff}}{(numeric) The difference between the xyz coefficient of an item in ABC/XYZ analysis A and the
xyz coefficient of the same item in ABC/XYZ analysis B that is required to consider the item in the comparison.}

\item{\code{unequalABC}}{(logical) If \code{TRUE} only items are returned, where the ABC-Classes are different. If FALSE only
items are returned, where the ABC-Classes are equal. If \code{NA}, no further restriction takes place based on the column ABC.}

\item{\code{unequalXYZ}}{(logical) If \code{TRUE} only items are returned, where the XYZ-Classes are different. If FALSE only
items are returned, where the XYZ-Classes are equal. If \code{NA}, no further restriction takes place based on the column XYZ.}
}}

\section{Objects from the Class}{
 Objects can be created by calling the function
\code{compare} function. This S4 class represents the result of a comparison of two
ABC/XYZ analysis results.
}

\examples{
data("Amount")
data1 = Amount[sample(1:nrow(Amount), 1000),]
data2 = Amount[sample(1:nrow(Amount), 1000),]
abcxyzData1 = computeABCXYZAnalysis(data1, value = "value", item = "item", timestamp = "date")
abcxyzData2 = computeABCXYZAnalysis(data2, value = "value", item = "item", timestamp = "date")
comparison = compare(abcxyzData1, abcxyzData2)
comparison
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{classes}
