% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{printMatrix}
\alias{printMatrix}
\title{Print a matrix, allowing fractions or LaTeX output}
\usage{
printMatrix(
  A,
  parent = TRUE,
  fractions = FALSE,
  latex = FALSE,
  tol = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{A}{A numeric matrix}

\item{parent}{flag used to search in the parent envir for suitable definitions of other arguments.
Set to \code{TRUE} (the default) if you want to only use the inputs provided.}

\item{fractions}{If \code{TRUE}, print numbers as rational fractions}

\item{latex}{If \code{TRUE}, print the matrix in LaTeX format}

\item{tol}{Tolerance for rounding small numbers to 0}
}
\value{
The formatted matrix
}
\description{
Print a matrix, allowing fractions or LaTeX output
}
\examples{
A <- matrix(1:12, 3, 4) / 6
printMatrix(A, fractions=TRUE)
printMatrix(A, latex=TRUE)
}
\seealso{
\code{\link[MASS]{fractions}}
}
