% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowops.R
\name{rowmult}
\alias{rowmult}
\title{Multiply Rows by Constants}
\usage{
rowmult(x, row, mult)
}
\arguments{
\item{x}{a matrix, possibly consisting of the coefficient matrix, A, joined with a vector of constants, b.}

\item{row}{index of one or more rows.}

\item{mult}{row multiplier(s)}
}
\value{
the matrix \code{x}, modified
}
\description{
Multiplies one or more rows of a matrix by constants. This corresponds to multiplying or dividing equations
by constants.
}
\examples{
A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
b <- c(8, -11, -3)

# using row operations to reduce below diagonal to 0
Ab <- cbind(A, b)
(Ab <- rowadd(Ab, 1, 2, 3/2))  # row 2 <- row 2 + 3/2 row 1
(Ab <- rowadd(Ab, 1, 3, 1))    # row 3 <- row 3 + 1 row 1
(Ab <- rowadd(Ab, 2, 3, -4))
# multiply to make diagonals = 1
(Ab <- rowmult(Ab, 1:3, c(1/2, 2, -1)))
# The matrix is now in triangular form

}
\seealso{
\code{\link{echelon}}, \code{\link{gaussianElimination}}

Other elementary row operations: \code{\link{rowadd}},
  \code{\link{rowswap}}
}
\concept{elementary row operations}
