% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{gaussianElimination}
\alias{gaussianElimination}
\title{Gaussian Elimination}
\usage{
gaussianElimination(A, B, tol = sqrt(.Machine$double.eps), verbose = FALSE,
  fractions = FALSE)
}
\arguments{
\item{A}{coefficient matrix}

\item{B}{right-hand side vector or matrix. If \code{B} is a matrix, the result gives solutions for each column as the right-hand
side of the equations with coefficients in \code{A}.}

\item{tol}{tolerance for checking for 0 pivot}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{fractions}{logical; if \code{TRUE}, try to express nonintegers as rational numbers}
}
\value{
If \code{B} is absent, returns the reduced row-echelon form of \code{A}.
        If \code{B} is present, returns the reduced row-echelon form of \code{A}, with the
        same operations applied to \code{B}.
}
\description{
\code{gaussianElimination} demonstrates the algorithm of row reduction used for solving
systems of linear equations of the form \eqn{A x = B}. Optional arguments \code{verbose}
and \code{fractions} may be used to see how the algorithm works.
}
\examples{
  A <- matrix(c(2, 1, -1,
               -3, -1, 2,
               -2,  1, 2), 3, 3, byrow=TRUE)
  b <- c(8, -11, -3)
  gaussianElimination(A, b)
  gaussianElimination(A, b, verbose=TRUE, fractions=TRUE)


}
\author{
John Fox
}

