% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{Ginv}
\alias{Ginv}
\title{Generalized Inverse of a Matrix}
\usage{
Ginv(A, tol = sqrt(.Machine$double.eps), verbose = FALSE,
  fractions = FALSE)
}
\arguments{
\item{A}{coefficient matrix}

\item{tol}{tolerance for checking for 0 pivot}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{fractions}{logical; if \code{TRUE}, try to express nonintegers as rational numbers}
}
\value{
the generalized inverse of \code{A}, expressed as fractions if \code{fractions=TRUE}, or rounded
}
\description{
Returns an arbitrary generalized inverse of the matrix \code{A}, using \code{gaussianElimination}.
}
\details{
Its purpose is only to show how the generalized inverse can be computed using
Gaussian elimination.
}
\examples{
A <- matrix(c(1,2,3,4,5,6,7,8,10), 3, 3) # a nonsingular matrix
A
Ginv(A, fractions=TRUE)  # a generalized inverse of A = inverse of A
round(Ginv(A) \%*\% A, 6)  # check

B <- matrix(1:9, 3, 3) # a singular matrix
B
Ginv(B, fractions=TRUE)  # a generalized inverse of B
B \%*\% Ginv(B) \%*\% B   # check

}
\seealso{
\code{\link[MASS]{ginv}} for a more generally usable function
}

