% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathml.R
\name{math}
\alias{math}
\title{Adds the class "math" to the object for knitr output via \code{mathout()}}
\usage{
math(term, flags = NULL)
}
\arguments{
\item{term}{an R call or symbol/number. This function translates \emph{term} into a
LaTeX/MathJax string.}

\item{flags}{(default NULL)
list of flags that control the translation}
}
\value{
\emph{term} with additional class "math" and \emph{flags} as attributes.
}
\description{
Adds the class "math" to the object for knitr output via \code{mathout()}
}
\examples{
math(term=quote((a + b)^2L == a^2L + 2L*a*b + b^2L))
}
\seealso{
\code{\link[=mathml]{mathml()}}, \code{\link[=mathjax]{mathjax()}}, \code{\link[=mathout]{mathout()}}
}
