% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convData.R
\name{makeSliceMap}
\alias{makeSliceMap}
\title{Make the maps for converting slice notation}
\usage{
makeSliceMap(leftSym, rightSym, rClass, matClass = "")
}
\arguments{
\item{leftSym}{The left symbol that contains the Matlab data}

\item{rightSym}{the right symbol that contains the Matlab data}

\item{rClass}{The formal r class name that defines what the R data is
outputted as}

\item{matClass}{The name of the Matlab class that should be converted}
}
\value{
A function that takes in a string and converts all the given slice
  notation
}
\description{
Make the maps for converting slice notation
}
\details{
Slice notation for matrices are tricky because they can easily be
  confused with the requirements for conversion are the bounds given by both
  left and right symbols or the Matlab class. The Matlab class allows for the
  conversion of structures but is really just a dictionary for the different 
  bounds.
}
\examples{
  sliceMap <- makeSliceMap("{", "}", "list")
  sliceMap("junk <- importData{300}")
  # "junk <- importData[[300]]"
  
  sliceMap <- makeSliceMap(matClass = "structure", rClass = "list")
  sliceMap("junk <- students.AP.GPA")
  # junk <- students[['AP']][['GPA']]
}

