/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.goals;

import choco.cp.solver.search.GoalSearchLoop;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.goals.GoalType;

public class Sequence
implements Goal {
    protected Goal[] sequence;

    public Sequence(Goal[] goals) {
        this.sequence = goals;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("and(");
        for (int i = 0; i < this.sequence.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Goal goal = this.sequence[i];
            sb.append(goal.pretty());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Goal execute(Solver s) throws ContradictionException {
        GoalSearchLoop gsl = (GoalSearchLoop)s.getSearchStrategy().searchLoop;
        for (int i = this.sequence.length - 1; i >= 0; --i) {
            Goal goal = this.sequence[i];
            gsl.pushGoal(goal);
        }
        return null;
    }

    @Override
    public GoalType getType() {
        return GoalType.SEQ;
    }
}

