/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.kernel.common.TimeCacheThread;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.GlobalSearchLimitManager;
import choco.kernel.solver.search.limit.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.limit.NoLimit;
import choco.kernel.solver.search.restart.NoRestartStrategy;
import choco.kernel.solver.search.restart.UniversalRestartStrategy;
import java.util.logging.Logger;

public class SearchLimitManager
implements GlobalSearchLimitManager {
    public static final Logger LOGGER = ChocoLogging.getSearchLogger();
    protected final AbstractGlobalSearchStrategy searchStrategy;
    protected AbstractGlobalSearchLimit restartLimit;
    protected AbstractGlobalSearchLimit searchLimit;
    protected UniversalRestartStrategy restartStrategy;
    protected AbstractGlobalSearchLimit restartStrategyLimit;
    private int restartCutoff = 0;
    private int restartFromStrategyCount = 0;
    private int timeCount;
    private long starth;

    public SearchLimitManager(AbstractGlobalSearchStrategy searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    public final AbstractGlobalSearchLimit getRestartLimit() {
        return this.restartLimit;
    }

    @Override
    public final UniversalRestartStrategy getRestartStrategy() {
        return this.restartStrategy;
    }

    public final AbstractGlobalSearchLimit getRestartStrategyLimit() {
        return this.restartStrategyLimit;
    }

    public final void setRestartLimit(AbstractGlobalSearchLimit restartLimit) {
        this.restartLimit = restartLimit == null ? NoLimit.SINGLOTON : restartLimit;
    }

    public final AbstractGlobalSearchLimit getSearchLimit() {
        return this.searchLimit;
    }

    public final void setSearchLimit(AbstractGlobalSearchLimit searchLimit) {
        this.searchLimit = searchLimit == null ? NoLimit.SINGLOTON : searchLimit;
    }

    public final void setRestartStrategy(UniversalRestartStrategy restartStrategy, AbstractGlobalSearchLimit restartStrategyLimit) {
        if (restartStrategyLimit == null || restartStrategy == null) {
            this.restartStrategyLimit = NoLimit.SINGLOTON;
            this.restartStrategy = NoRestartStrategy.SINGLOTON;
        } else {
            this.restartStrategy = restartStrategy;
            this.restartStrategyLimit = restartStrategyLimit;
        }
    }

    @Override
    public final int getRestartFromStrategyCount() {
        return this.restartFromStrategyCount;
    }

    public final int getRestartCutoff() {
        return this.restartCutoff;
    }

    @Override
    public final int getTimeCount() {
        return this.timeCount;
    }

    @Override
    public final AbstractGlobalSearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    protected final void updateTimeCount() {
        this.timeCount = (int)(TimeCacheThread.currentTimeMillis - this.starth);
    }

    @Override
    public final void initialize() {
        TimeCacheThread.currentTimeMillis = this.starth = System.currentTimeMillis();
        this.restartFromStrategyCount = 0;
        this.restartCutoff = this.restartStrategy.getScaleFactor();
        this.restartStrategyLimit.setNbMax(this.restartCutoff);
    }

    @Override
    public final void reset() {
        this.updateTimeCount();
        this.restartStrategyLimit.setNbMax(this.restartStrategyLimit.getNb() + this.restartCutoff);
    }

    @Override
    public void endTreeSearch() {
        TimeCacheThread.currentTimeMillis = System.currentTimeMillis();
        this.updateTimeCount();
    }

    @Override
    public final void newNode() throws ContradictionException {
        this.updateTimeCount();
        if (this.searchLimit.getNb() >= this.searchLimit.getNbMax()) {
            this.searchStrategy.setEncounteredLimit(this.searchLimit);
            this.searchStrategy.solver.getPropagationEngine().raiseContradiction(this.searchLimit, 16);
        }
        if (this.restartStrategyLimit.getNb() >= this.restartStrategyLimit.getNbMax()) {
            ++this.restartFromStrategyCount;
            this.restartCutoff = this.restartStrategy.getNextCutoff(this.restartFromStrategyCount);
            this.restartStrategyLimit.setNbMax(this.restartStrategyLimit.getNb() + this.restartCutoff);
            this.searchStrategy.solver.getPropagationEngine().raiseContradiction(this.searchLimit, 8);
        }
    }

    @Override
    public final void endNode() throws ContradictionException {
        this.updateTimeCount();
        if (this.searchLimit.getNb() >= this.searchLimit.getNbMax()) {
            this.searchStrategy.setEncounteredLimit(this.searchLimit);
            this.searchStrategy.solver.getPropagationEngine().raiseContradiction(this.searchLimit, 16);
        }
    }

    @Override
    public final boolean newRestart() {
        return this.restartLimit.getNb() >= this.restartLimit.getNbMax();
    }

    @Override
    public final void cancelRestartStrategy() {
        this.restartStrategyLimit = NoLimit.SINGLOTON;
    }

    public String toString() {
        if (this.searchLimit != null && this.searchLimit.getUnit() != "unlimited") {
            return this.searchLimit.pretty();
        }
        return "";
    }

    @Override
    public String pretty() {
        if (this.restartLimit != null && this.restartLimit.getUnit() != "unlimited") {
            return this.toString() + ",  restart: " + this.restartLimit.pretty();
        }
        return this.toString();
    }
}

