% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balanceTable.R
\name{balanceTable}
\alias{balanceTable}
\title{Create Balance Table}
\usage{
balanceTable(
  df.orig,
  df.match = NULL,
  treatment,
  school.id = NULL,
  var.names = NULL,
  include.tests = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{df.orig}{a data frame containing the data before matching}

\item{df.match}{an optional data frame containing the matched sample. Must
have all variable names to be balanced.}

\item{treatment}{name of the binary indicator for treatment status}

\item{school.id}{Identifier for groups (for example schools); need to pass if
p-values for balance statistics are desired.}

\item{var.names}{List of variable names to calculate balance for.  If NULL,
use all variables found in the df.orig data.frame.}

\item{include.tests}{Include tests of imbalance on covariates (TRUE/FALSE).}

\item{verbose}{a logical value indicating whether detailed output should be
printed.}
}
\value{
A data.frame of balance measures, with one row for each covariate in
  \code{df.orig} except \code{treatment}, and columns for treated and control
  means, standardized differences in means, p-values from two types of
  regression for difference in the groups.  See description for further
  details. If \code{df.match} is specified there are twice as many columns,
  one set for the pre-match samples and one set for the post-match samples.
}
\description{
Given an unmatched sample of treated and control units and (optionally) a
matched sample from the same data, produces a table with pre- and post-match
measures of covariate balance.
}
\details{
This table can also include p-values for tests of whether the balance is
statistically significant.  These tests assume randomization at the cluster
level.  We recommend looking at the standardized differences rather than
p-values to assess severity of imbalance, however.

The two tests, for each covariate are (1) Aggregation, where the covariates
are averaged by each cluster, followed by a heteroskedastic robust t-test on
the coefficient of a regression of these averages onto treatment (and
intercept) and (2) cluster robust standard errors for the coefficient of
treatment on a regression of covariate onto treatment (and intercept).
}
\references{
Rosenbaum, Paul R. (2002). \emph{Observational Studies}.
  Springer-Verlag.

  Rosenbaum, Paul R. (2010). \emph{Design of Observational Studies}.
  Springer-Verlag.
}
\keyword{internal}
