% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_list_from_mat.R
\name{create_list_from_mat}
\alias{create_list_from_mat}
\title{Create a list representation of a distance matrix.}
\usage{
create_list_from_mat(
  Z,
  dist_mat,
  p = NULL,
  caliper = NULL,
  k = NULL,
  penalty = Inf
)
}
\arguments{
\item{Z}{A length (n = n_t + n_c) vector of treatment indicators.}

\item{dist_mat}{A treatment-by-control (n_t-by-n_c) distance matrix.}

\item{p}{A vector of length (n_t + n_c) on which caliper applies (e.g. propensity scores)}

\item{caliper}{Size of the caliper.}

\item{k}{Connect each treated to the nearest k controls}

\item{penalty}{Penalty for violating the caliper. Set to Inf by default.}
}
\value{
This function returns a list that consists of three arguments: start_n, end_n, and d,
        as described above.
}
\description{
This function creates a ``list representation''
of a treatment-by-control distance matrix.
}
\details{
This function creates a list representation of a treatment-by-control
network. The list representation can be made sparse using a user-specified
caliper. A list representation of a treatment-by-control distance matrix
consists of the following arguments:
\itemize{
\item start_n: a vector containing the node numbers of
             the start nodes of each arc in the network.
\item end_n: a vector containing the node numbers of
           the end nodes of each arc in the network.
\item d: a vector containing the integer cost of
           each arc in the network.
}
Node 1,2,...,n_t are n_t treatment nodes; n_t + 1, n_t + 2, ..., n_t + n_c
are n_c control nodes. start_n, end_n, and d should have the same lengths,
all of which equal to the number of edges.

There are two options for users to make a network sparse. Option caliper
is a value applied to the vector p to avoid connecting treated to controls
whose covariate or propensity score defined by p is outside p +/- caliper.
Second, within a specified caliper, sometimes there are still too many controls
connected to each treated, and we can further trim down this number up to k
by restricting our attention to the k nearest (in p) to each treated.

By default a hard caliper is applied, i.e., option penalty is set to Inf by default.
Users may make the caliper a soft one by setting penalty to a large yet finite number.
}
