% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{rollup_mass_props_unc}
\alias{rollup_mass_props_unc}
\title{Roll up mass properties uncertainties}
\usage{
rollup_mass_props_unc(
  tree,
  df,
  validate_df = validate_mass_props_and_unc_table,
  ...
)
}
\arguments{
\item{tree}{An 'igraph' tree whose vertices are named as the values of the \code{id}
column of \code{df} and whose directed edges point from child id to parent id.}

\item{df}{A data frame  with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.}

\item{validate_df}{A validator for the tree and table, default \code{validate_mass_props_and_unc_table()}}

\item{...}{Other parameters passed to \code{rollupTree::rollup()}}
}
\value{
The updated data frame
}
\description{
\code{rollup_mass_props_unc()} rolls up mass properties uncertainties in a data frame such that the uncertainties of each
non-leaf vertex element is the aggregation of the mass properties and uncertainties of its child elements.

The difference between \code{rollup_mass_props_unc()} and \code{rollup_mass_props_and_unc()} is that \code{rollup_mass_props_unc()}
expects the mass properties in its input to have been rolled up, whereas \code{rollup_mass_props_and_unc()} performs
the mass properties rollup itself.
}
\examples{
mp_ru <- rollup_mass_props(mp_tree_small, mp_table_small)
rollup_mass_props_unc(mp_tree_small, mp_ru)
}
