% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\title{Design the blueprint for an analysis.}
\usage{
design(data, statistic = c("gee", "cor", "glm", "t.test"))
}
\arguments{
\item{data}{The dataset you want to analyze}

\item{statistic}{The type of statistical test to use}
}
\value{
Creates a blueprint object that will be used to construct the
analysis in a later phase.
}
\description{
Sets up the initial design (i.e. the blueprint) of a statistical analysis to
use on the data. As in creating a building or structure, a blueprint is first
needed to guide the construction. This function \emph{only} creates that
blueprint, but does not do any construction (e.g. actually running statistics).
}
\examples{

design(iris, 'gee')
design(iris, 'cor')
design(iris, 'glm')
design(iris, 't.test')

}
