% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm.R
\name{rangeSVM}
\alias{rangeSVM}
\title{Classify species ranges based on occurrence coordinates and SDM scores.}
\usage{
rangeSVM(xy1, xy2, ..., sdm = NULL, nrep = 100, weight = FALSE, mc.cores = 1)
}
\arguments{
\item{xy1}{Matrix or data frame of occurrence coordinates for species 1.}

\item{xy2}{Matrix or data frame of occurrence coordinates for species 2.}

\item{...}{Other matrices or data frames of occurrence coordinates for additional species.}

\item{sdm}{Raster or RasterStack representing environmental suitability (can be predictions from SDMs). 
These must have the same extent as both species' occurrence points. Default is NULL.}

\item{nrep}{Numeric for number of SVM tuning iterations. Default is 100.}

\item{weight}{Boolean. If TRUE, species with fewer occurrence records are weighted higher in the SVM. Default is FALSE.}

\item{mc.cores}{Number of cores to use for parallel processing. Default is 1.}
}
\value{
The tuned SVM model.
}
\description{
\code{rangeSVM()} returns a tuned support vector machine (SVM) model that predicts 
species identity based on predictors that are solely spatial, based on occurrence coordinates,
or a combination of spatial and environmental, based on both occurrence coordinates and 
environmental suitability values. Suitability values can be predicted with species distribution
models (SDMs; a.k.a. ecological niche models).
}
\details{
The tuning operation uses \code{tune.svm()} from the e1071 package, which performs 10-fold
cross validation and selects the best model based on classification error. Ranges of the cost and gamma
parameters are explored in the tuning exercise. The tuning function is iterated \code{nrep} times, and the
parameter combination used most frequently across all iterations is used to build a final SVM model.

When \code{sdm = NULL}, the SVM is purely spatial, based only on the occurrence coordinates of
each species. Otherwise, the SVM is fit with both a spatial predictor and any additional ones added as
rasters. These extra predictors can be based on predictions from a species distribution model 
(SDM; a.k.a. ecological niche model), and in this case would represent environmental or climatic
suitability, depending on the variables used in the SDM.
}
\examples{
\donttest{
r1.sdm <- raster::raster(raster::extent(c(-72, -64, 41, 50)), res = c(0.008333333, 0.008333333))
raster::values(r1.sdm) <- (1:raster::ncell(r1.sdm))^2
r2.sdm <- raster::raster(raster::extent(c(-72, -64, 41, 50)), res = c(0.008333333, 0.008333333))
raster::values(r2.sdm) <- (raster::ncell(r2.sdm):1)^2
r3.sdm <- raster::raster(raster::extent(c(-72, -64, 41, 50)), res = c(0.008333333, 0.008333333))
r3.sdm [1] <- 10
r3.sdm <- raster::distance(r3.sdm)
sp1.xy <- data.frame(dismo::randomPoints(r1.sdm, 15, prob = TRUE))
colnames(sp1.xy) <- c("longitude", "latitude")
sp2.xy <- data.frame(dismo::randomPoints(r2.sdm, 15, prob = TRUE))
colnames(sp2.xy) <- c("longitude", "latitude")
sp3.xy <- data.frame(dismo::randomPoints(r3.sdm, 15, prob = TRUE))
colnames(sp3.xy) <- c("longitude", "latitude")
# Spatial SVMs (this can take about a minute to run)
svm.SP <- rangeSVM(sp1.xy, sp2.xy, sp3.xy, nrep=5) # more reps are recommended
}

}
