% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_marquee.R
\name{element_marquee}
\alias{element_marquee}
\title{ggplot2 theme element supporting marquee syntax}
\usage{
element_marquee(
  family = NULL,
  colour = NULL,
  size = NULL,
  hjust = NULL,
  vjust = NULL,
  angle = NULL,
  lineheight = NULL,
  color = NULL,
  margin = NULL,
  style = NULL,
  width = NULL,
  inherit.blank = FALSE
)
}
\arguments{
\item{family}{The font family of the base style}

\item{colour, color}{The font colour of the base style}

\item{size}{The font size of the base style}

\item{hjust}{Horizontal justification (in \eqn{[0, 1]})}

\item{vjust}{Vertical justification (in \eqn{[0, 1]})}

\item{angle}{Angle (in \eqn{[0, 360]})}

\item{lineheight}{The lineheight of the base style}

\item{margin}{The margin for the body tag. As margins in \code{element_text()}
doesn't rotate along with \code{angle} we follow this behavior here as well so
that the right margin becomes the bottom margin when rotating the text 90
degrees and so forth.}

\item{style}{A style set to base the rendering on}

\item{width}{The maximum width of the text. See the description for some
caveats for this}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}
}
\value{
An \code{element_marquee} object that can be used in place of
\code{element_text} in ggplot2 theme specifications
}
\description{
This theme element is a drop-in replacement for \code{ggplot2::element_text()}. It
works by integrating the various style settings of the element into the base
style of the provided style set. If a margin is given, it is set on the body
tag with \code{\link[=skip_inherit]{skip_inherit()}}. The default width is \code{NA} meaning that it will
span as long as the given text is, doing no line wrapping. You can set it to
any unit to make it fit within a specific width. However, this may not work
as expected with rotated text (you may get lucky). Note that you may see
small shifts in the visuals when going from \code{element_text()} to
\code{element_marquee()} as size reporting may differ between the two elements.
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
p <- ggplot(mtcars) +
  geom_point(aes(mpg, disp)) +
  labs(title = "A {.red *marquee*} title\n* Look at this bullet list\n\n* great, huh?") +
  theme_gray(base_size = 6) +
  theme(title = element_marquee())

plot(p)

ggplot(mtcars) +
  geom_histogram(aes(x = mpg)) +
  labs(title =
"I put a plot in your title so you can plot while you title

![](p)

What more could you _possibly_ want?") +
  theme(title = element_marquee())
\dontshow{\}) # examplesIf}
}
