% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_hommc.R
\docType{class}
\name{hommc-class}
\alias{hommc-class}
\alias{hommc}
\title{An S4 class for representing High Order Multivariate Markovchain (HOMMC)}
\description{
An S4 class for representing High Order Multivariate Markovchain (HOMMC)
}
\section{Slots}{

\describe{
\item{\code{order}}{an integer equal to order of Multivariate Markovchain}

\item{\code{states}}{a vector of states present in the HOMMC model}

\item{\code{P}}{array of transition matrices}

\item{\code{Lambda}}{a vector which stores the weightage of each transition matrices in P}

\item{\code{byrow}}{if FALSE each column sum of transition matrix is 1 else row sum = 1}

\item{\code{name}}{a name given to hommc}
}}

\examples{
statesName <- c("a", "b")

P <- array(0, dim = c(2, 2, 4), dimnames = list(statesName, statesName))
P[,,1] <- matrix(c(0, 1, 1/3, 2/3), byrow = FALSE, nrow = 2)
P[,,2] <- matrix(c(1/4, 3/4, 0, 1), byrow = FALSE, nrow = 2)
P[,,3] <- matrix(c(1, 0, 1/3, 2/3), byrow = FALSE, nrow = 2)
P[,,4] <- matrix(c(3/4, 1/4, 0, 1), byrow = FALSE, nrow = 2)

Lambda <- c(0.8, 0.2, 0.3, 0.7)

ob <- new("hommc", order = 1, states = statesName, P = P, 
          Lambda = Lambda, byrow = FALSE, name = "FOMMC")
}
\author{
Giorgio Spedicato, Deepak Yadav
}
