% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_ctmcProbabilisticSAI.R
\name{transition2Generator}
\alias{transition2Generator}
\title{Return the generator matrix for a corresponding transition matrix}
\usage{
transition2Generator(P, t = 1, method = "logarithm")
}
\arguments{
\item{P}{transition matrix between time 0 and t}

\item{t}{time of observation}

\item{method}{"logarithm" returns the Matrix logarithm of the transition matrix}
}
\value{
A matrix that represent the generator of P
}
\description{
Calculate the generator matrix for a 
             corresponding transition matrix
}
\examples{
mymatr <- matrix(c(.4, .6, .1, .9), nrow = 2, byrow = TRUE)
Q <- transition2Generator(P = mymatr)
expm::expm(Q)
 
}
\seealso{
\code{\link{rctmc}}
}
