% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msld_tmb.r
\name{msld_tmb}
\alias{msld_tmb}
\title{Fitting function for Multistate CJS live-dead models with TMB}
\usage{
msld_tmb(
  x,
  ddl,
  fullddl,
  dml,
  model_data = NULL,
  parameters,
  accumulate = TRUE,
  initial = NULL,
  method,
  hessian = FALSE,
  debug = FALSE,
  chunk_size = 1e+07,
  refit,
  itnmax = NULL,
  control = NULL,
  scale,
  re = FALSE,
  compile = FALSE,
  extra.args = "",
  clean = FALSE,
  getreals = FALSE,
  useHess = FALSE,
  ...
)
}
\arguments{
\item{x}{processed dataframe created by process.data}

\item{ddl}{list of simplified dataframes for design data; created by call to
\code{\link{make.design.data}}}

\item{fullddl}{list of complete dataframes for design data; created by call to
\code{\link{make.design.data}}}

\item{dml}{list of design matrices created by \code{\link{create.dm}} from
formula and design data}

\item{model_data}{a list of all the relevant data for fitting the model including
imat, S.dm,r.dm,p.dm,Psi.dm,S.fixed,r.fixed,p.fixed,Psi.fixed and time.intervals. It is used to save values
and avoid accumulation again if the model was re-rerun with an additional call to cjs when
using autoscale or re-starting with initial values.  It is stored with returned model object.}

\item{parameters}{equivalent to \code{model.parameters} in \code{\link{crm}}}

\item{accumulate}{if TRUE will accumulate capture histories with common
value and with a common design matrix for all parameters speed up execution}

\item{initial}{list of initial values for parameters if desired; if each is a named vector
from previous run it will match to columns with same name}

\item{method}{method to use for optimization; see \code{optim}}

\item{hessian}{if TRUE will compute and return the hessian}

\item{debug}{if TRUE will print out information for each iteration}

\item{chunk_size}{specifies amount of memory to use in accumulating capture
histories; amount used is 8*chunk_size/1e6 MB (default 80MB)}

\item{refit}{non-zero entry to refit}

\item{itnmax}{maximum number of iterations}

\item{control}{control string for optimization functions}

\item{scale}{vector of scale values for parameters}

\item{re}{if TRUE creates random effect model admbcjsre.tpl and runs admb optimizer}

\item{compile}{if TRUE forces re-compilation of tpl file}

\item{extra.args}{optional character string that is passed to tmb}

\item{clean}{if TRUE, deletes the dll and recompiles}

\item{getreals}{if TRUE, compute real values and std errors for TMB models; may want to set as FALSE until model selection is complete}

\item{useHess}{if TRUE, the TMB hessian function is used for optimization; using hessian is typically slower with many parameters but can result in a better solution}

\item{...}{not currently used}
}
\value{
The resulting value of the function is a list with the class of
crm,cjs such that the generic functions print and coef can be used.
\item{beta}{named vector of parameter estimates} \item{lnl}{-2*log
likelihood} \item{AIC}{lnl + 2* number of parameters}
\item{convergence}{result from \code{optim}; if 0 \code{optim} thinks it
converged} \item{count}{\code{optim} results of number of function
evaluations} \item{reals}{dataframe of data and real S and p estimates for
each animal-occasion excluding those that occurred before release}
\item{vcv}{var-cov matrix of betas if hessian=TRUE was set}
}
\description{
A function for computing MLEs for a Multi-state Cormack-Jolly-Seber open
population capture-recapture with dead recoveries for processed dataframe \code{x} with
user specified formulas in \code{parameters} that create list of design
matrices \code{dml}. This function can be called directly but is most easily
called from \code{\link{crm}} that sets up needed arguments.
}
\details{
It is easiest to call \code{msld_tmb} through the function \code{\link{crm}}.
Details are explained there.
}
\references{
Ford, J. H., M. V. Bravington, and J. Robbins. 2012. Incorporating individual variability into mark-recapture models. Methods in Ecology and Evolution 3:1047-1054.
}
\author{
Jeff Laak
}
