% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-arg.R
\name{match_arg}
\alias{match_arg}
\title{Match arguments}
\usage{
match_arg(x, table)
}
\arguments{
\item{x}{An argument}

\item{table}{A table of choices}
}
\value{
A single value from \code{x} matched on \code{table}
}
\description{
This function is essentially a clear version of \code{\link[base:match.arg]{base::match.arg()}} which
produces a cleaner warning message and does not restrict the \code{table} param
to \code{character} vectors only.
}
\details{
Match arguments
}
\examples{
x <- c("apple", "banana", "orange")
match_arg("b", x)

# Produces error
try(match_arg("pear", x))

foo <- function(x, op = c(1, 2, 3)) {
  op <- match_arg(op)
  x / op
}

foo(10, 3)

# Error
try(foo(1, 0))
}
\seealso{
\code{\link[=match_param]{match_param()}}
}
