% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanMaxAge.R
\name{meanMaxAge}
\alias{meanMaxAge}
\title{Calculates the Mean Maximum Age of fish in the community}
\usage{
meanMaxAge(X, age.table, metric = "BIOMASS", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{BIOMASS} is the corresponding biomass (stratified
and corrected for catchability as required).}

\item{age.table}{A dataframe with columns \code{SPECIES} and \code{MAXAGE},
the maximum recorded age of the corresponding species. Entries in the
\code{SPECIES} column should be the unique values of species codes in
\code{X} (or a subset thereof). Other columns in \code{age.table} are
ignored.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with 3 columns: \code{ID}, \code{YEAR}, and
 \code{MeanLifespan}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 value is assigned NA.
}
\description{
This function calculates the Mean Maximum Age (MMA) of fish in
 the community for \eqn{j} areas and \eqn{i} years.
}
\details{
Mean Maximum Age: \deqn{Mean Maximum Age = \Sigma
 (age_{max,i}*B_i)/\Sigma B_i} where the sum is over all species \eqn{i}, and
 \eqn{B_i} is biomass of species \eqn{i}. The mean lifespan or longevity is
 considered to be a fixed parameter per species. Lifespan may vary under
 fishing pressure, so Shin et al. (2010) adopted the maximum longevity
 observed for each species (\eqn{age_{max,i}}). The variation of this
 indicator captures changes in species composition, and therefore changes in
 average lifespan (Shin et al., 2010).
}
\examples{
# Compile data
data(X)
data(species.info)

# Calculate indicator
meanMaxAge(X, age.table = species.info, metric = "BIOMASS", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Shin, YJ, Shannon LJ, Bundy A, Coll M, Aydin K, Bez N, Blanchard JL, Borges,
 MF, Diallo I, Diaz E, Heymans JJ, Hill L, Johannesen E, Jouffre D, Kifani S,
 Labrosse P, Link JS, Mackinson S, Masski H, Möllmann C, Neira S, Ojaveer H,
 Abdallahi KM, Perry I, Thiao D, Yemane D, and Cury PM. 2010. Using
 indicators for evaluating, comparing and communicating the ecological status
 of exploited marine ecosystems. Part 2: Setting the scene. ICES Journal of
 Marine Science, 67: 692-716
}
\seealso{
Other stability and resistance indicators: \code{\link{CVBiomass}},
  \code{\link{IVILandings}}, \code{\link{allStability}},
  \code{\link{biomassPerTL}}, \code{\link{meanMaxLength}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{stability and resistance indicators}
