% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_aod.R, R/methods_betareg.R,
%   R/sanity_model.R, R/methods_brms.R, R/methods_dbarts.R, R/methods_glmmTMB.R,
%   R/methods_lme4.R, R/methods_mclogit.R, R/methods_mlogit.R,
%   R/methods_ordinal.R, R/methods_plm.R, R/methods_quantreg.R,
%   R/methods_survey.R
\name{sanitize_model_specific.glimML}
\alias{sanitize_model_specific.glimML}
\alias{sanitize_model_specific.betareg}
\alias{sanitize_model_specific}
\alias{sanitize_model_specific.default}
\alias{sanitize_model_specific.brmsfit}
\alias{sanitize_model_specific.bart}
\alias{sanitize_model_specific.glmmTMB}
\alias{sanitize_model_specific.merMod}
\alias{sanitize_model_specific.mblogit}
\alias{sanitize_model_specific.mlogit}
\alias{sanitize_model_specific.clm}
\alias{sanitize_model_specific.plm}
\alias{sanitize_model_specific.rqs}
\alias{sanitize_model_specific.svyolr}
\alias{sanitize_model_specific.svyglm}
\title{Method to raise model-specific warnings and errors}
\usage{
\method{sanitize_model_specific}{glimML}(model, ...)

\method{sanitize_model_specific}{betareg}(model, ...)

sanitize_model_specific(model, ...)

\method{sanitize_model_specific}{default}(
  model,
  vcov = NULL,
  calling_function = "marginaleffects",
  ...
)

\method{sanitize_model_specific}{brmsfit}(model, ...)

\method{sanitize_model_specific}{bart}(model, ...)

\method{sanitize_model_specific}{glmmTMB}(model, vcov = TRUE, re.form = NULL, ...)

\method{sanitize_model_specific}{merMod}(model, re.form = NULL, ...)

\method{sanitize_model_specific}{mblogit}(model, calling_function = "marginaleffects", ...)

\method{sanitize_model_specific}{mlogit}(model, newdata, ...)

\method{sanitize_model_specific}{clm}(model, ...)

\method{sanitize_model_specific}{plm}(model, ...)

\method{sanitize_model_specific}{plm}(model, ...)

\method{sanitize_model_specific}{rqs}(model, ...)

\method{sanitize_model_specific}{svyolr}(model, wts = FALSE, by = FALSE, ...)

\method{sanitize_model_specific}{svyglm}(model, wts = FALSE, by = FALSE, ...)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?slopes} documentation for a non-exhaustive list of available
arguments.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{newdata}{Grid of predictor values at which we evaluate the slopes.
\itemize{
\item Warning: Please avoid modifying your dataset between fitting the model and calling a \code{marginaleffects} function. This can sometimes lead to unexpected results.
\item \code{NULL} (default): Unit-level slopes for each observed value in the dataset (empirical distribution). The dataset is retrieved using \code{\link[insight:get_data]{insight::get_data()}}, which tries to extract data from the environment. This may produce unexpected results if the original data frame has been altered since fitting the model.
\item \code{\link[=datagrid]{datagrid()}} call to specify a custom grid of regressors. For example:
\itemize{
\item \code{newdata = datagrid(cyl = c(4, 6))}: \code{cyl} variable equal to 4 and 6 and other regressors fixed at their means or modes.
\item See the Examples section and the \code{\link[=datagrid]{datagrid()}} documentation.
}
\item \code{\link[=subset]{subset()}} call with a single argument to select a subset of the dataset used to fit the model, ex: \code{newdata = subset(treatment == 1)}
\item \code{\link[dplyr:filter]{dplyr::filter()}} call with a single argument to select a subset of the dataset used to fit the model, ex: \code{newdata = filter(treatment == 1)}
\item string:
\itemize{
\item "mean": Marginal Effects at the Mean. Slopes when each predictor is held at its mean or mode.
\item "median": Marginal Effects at the Median. Slopes when each predictor is held at its median or mode.
\item "marginalmeans": Marginal Effects at Marginal Means. See Details section below.
\item "tukey": Marginal Effects at Tukey's 5 numbers.
\item "grid": Marginal Effects on a grid of representative numbers (Tukey's 5 numbers and unique values of categorical predictors).
}
}}

\item{wts}{logical, string or numeric: weights to use when computing average predictions, contrasts or slopes. These weights only affect the averaging in \verb{avg_*()} or with the \code{by} argument, and not unit-level estimates. See \code{?weighted.mean}
\itemize{
\item string: column name of the weights variable in \code{newdata}. When supplying a column name to \code{wts}, it is recommended to supply the original data (including the weights variable) explicitly to \code{newdata}.
\item numeric: vector of length equal to the number of rows in the original data or in \code{newdata} (if supplied).
\item FALSE: Equal weights.
\item TRUE: Extract weights from the fitted object with \code{insight::find_weights()} and use them when taking weighted averages of estimates. Warning: \code{newdata=datagrid()} returns a single average weight, which is equivalent to using \code{wts=FALSE}
}}

\item{by}{Aggregate unit-level estimates (aka, marginalize, average over). Valid inputs:
\itemize{
\item \code{FALSE}: return the original unit-level estimates.
\item \code{TRUE}: aggregate estimates for each term.
\item Character vector of column names in \code{newdata} or in the data frame produced by calling the function without the \code{by} argument.
\item Data frame with a \code{by} column of group labels, and merging columns shared by \code{newdata} or the data frame produced by calling the same function without the \code{by} argument.
\item See examples below.
\item For more complex aggregations, you can use the \code{FUN} argument of the \code{hypotheses()} function. See that function's documentation and the Hypothesis Test vignettes on the \code{marginaleffects} website.
}}
}
\value{
A warning, an error, or nothing
}
\description{
Method to raise model-specific warnings and errors
}
\keyword{internal}
