% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.maq}
\alias{plot.maq}
\title{Plot the estimated Qini curve.}
\usage{
\method{plot}{maq}(
  x,
  ...,
  add = FALSE,
  horizontal.line = TRUE,
  ci.args = list(),
  grid.step = NULL
)
}
\arguments{
\item{x}{A maq object.}

\item{...}{Additional arguments passed to plot.}

\item{add}{Whether to add to an already existing plot. Default is FALSE.}

\item{horizontal.line}{Whether to draw a horizontal line where the Qini curve plateaus.
Only applies if add = TRUE and the maq object is fit with a maximum \code{budget} that is sufficient
to treat all units that are expected to benefit.
Default is TRUE.}

\item{ci.args}{A list of optional arguments to \code{lines()} for drawing 95 \% confidence bars.
Set to NULL to ignore CIs.}

\item{grid.step}{The spend grid increment size to plot the curve on. Default is
\code{max(floor(length(path.length) / 1000), 1)} where path.length is the size of the
grid underlying the estimated Qini curve.}
}
\description{
Plot the estimated curve \eqn{Q(B), B \in (0, B_{max}]}. If the underlying estimated policy
\eqn{\pi_B} entails treating zero units, then this function returns an empty value.
}
