% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_raster.R
\name{mf_raster}
\alias{mf_raster}
\title{Plot a raster}
\usage{
mf_raster(
  x,
  type,
  nbreaks,
  breaks = "equal",
  val_order,
  pal,
  expandBB = rep(0, 4),
  alpha = NULL,
  rev = FALSE,
  leg_pos = "right",
  leg_title = names(x),
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 1,
  leg_frame = FALSE,
  leg_frame_border,
  leg_horiz = FALSE,
  leg_adj = c(0, 0),
  leg_box_border,
  leg_box_cex = c(1, 1),
  leg_fg,
  leg_bg,
  leg_size = 1,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{a SpatRaster}

\item{type}{type of raster map, one of "continuous", "classes", or
"interval". Default type for a numeric and categorial raster are
"continuous" and "classes" respectively.}

\item{nbreaks}{number of classes}

\item{breaks}{either a numeric vector with the actual breaks
(for type = "continuous" and type = "interval"), or a
classification method name (for type = "interval" only;
see \link{mf_get_breaks} for classification methods)}

\item{val_order}{values order, a character vector that matches var modalities}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{expandBB}{fractional values to expand the bounding box with, in each
direction (bottom, left, top, right)}

\item{alpha}{opacity, in the range [0,1]}

\item{rev}{if \code{pal} is a \link{hcl.colors} palette name, whether the ordering of the colors should be reversed (TRUE) or not (FALSE)}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_frame_border}{border color of the legend frame}

\item{leg_horiz}{display the legend horizontally}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_box_border}{border color of legend boxes}

\item{leg_box_cex}{width and height size expansion of boxes}

\item{leg_fg}{color of the legend foreground}

\item{leg_bg}{color of the legend backgournd}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE)}

\item{...}{bgalpha, smooth, maxcell or other arguments passed to be
passed to
\code{\link[terra:plotRGB]{plotRGB}} or \code{\link[terra:plot]{plot}}}
}
\value{
x is (invisibly) returned.
}
\description{
Plot a raster object (SpatRaster from terra).
}
\examples{
if (require("terra")) {
  # multi band
  logo <- rast(system.file("ex/logo.tif", package = "terra"))
  mf_raster(logo)

  # one band
  elev <- rast(system.file("ex/elev.tif", package = "terra"))

  ## continuous
  mf_raster(elev)
  mf_raster(elev,
    pal = "Burg", expandBB = c(.2, 0, 0, 0),
    leg_pos = "bottom", leg_horiz = TRUE
  )

  ## continuous with colors and breaks
  mf_raster(elev,
    type = "continuous",
    breaks = c(141, 400, 547),
    pal = c("darkseagreen1", "black", "red")
  )

  ## interval
  mf_raster(elev,
    type = "interval",
    nbreaks = 5, breaks = "equal", pal = "Teal"
  )

  ## classes
  elev2 <- classify(elev, c(140, 400, 450, 549))
  lev_evel <- data.frame(ID = 0:2, elevation = c("Low", "High", "Super High"))
  levels(elev2) <- lev_evel
  mf_raster(elev2)
  mf_raster(elev2,
    pal = c("salmon4", "olivedrab", "yellow3"),
    val_order = c("Super High", "High", "Low")
  )
}
}
