% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_leg_s.R
\name{mf_legend_s}
\alias{mf_legend_s}
\title{Plot a legend for a symbols map}
\usage{
mf_legend_s(
  pos = "right",
  val,
  pal,
  pt_pch,
  pt_cex,
  border,
  lwd = 0.7,
  title = "Legend title",
  title_cex = 0.8,
  val_cex = 0.6,
  pt_cex_na = 1,
  pt_pch_na = 4,
  col_na = "white",
  no_data = FALSE,
  no_data_txt = "No Data",
  frame = FALSE,
  bg,
  fg,
  cex = 1
)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top",
"topright", "right", "bottomright", "bottom", "bottomleft",
"left", "interactive" or a vector of two coordinates in map units
(c(x, y)).}

\item{val}{vector of categories.}

\item{pal}{a set of colors}

\item{pt_pch}{pch of the symbols (0:25)}

\item{pt_cex}{cex of the symbols}

\item{border}{type = "prop": color of the symbols borders}

\item{lwd}{width of the symbols borders}

\item{title}{title of the legend}

\item{title_cex}{size of the legend title}

\item{val_cex}{size of the values in the legend}

\item{pt_cex_na}{cex of the symbols for missing values}

\item{pt_pch_na}{pch of the symbols for missing values}

\item{col_na}{color for missing values}

\item{no_data}{if TRUE a "missing value" box is plotted}

\item{no_data_txt}{label for missing values.}

\item{frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{bg}{background of the legend}

\item{fg}{foreground of the legend}

\item{cex}{size of the legend; 2 means two times bigger}
}
\value{
No return value, a legend is displayed.
}
\description{
This function can plot a legend for a symbols maps.
}
\examples{
plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
mf_legend_s(
  val = c("Type C", "Type D"), pal = c("cyan", "plum"),
  pt_pch = c(21, 23), pt_cex = c(1, 2)
)
}
\keyword{internal}
