% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_get_pencil.R
\name{mf_get_pencil}
\alias{mf_get_pencil}
\title{Get a pencil layer from polygons}
\usage{
mf_get_pencil(x, size = 100, buffer = 0, lefthanded = TRUE, clip = FALSE)
}
\arguments{
\item{x}{an sf object, a simple feature collection (POLYGON or MULTIPOLYGON).}

\item{size}{density of the penciling. Median number of points used to build
the MULTILINESTRING.}

\item{buffer}{buffer around each polygon. This buffer (in map units) is used
to take sample points. A negative value adds a margin between the penciling
and the original polygons borders}

\item{lefthanded}{if TRUE the penciling is done left-handed style.}

\item{clip}{if TRUE, the penciling is cut by the original polygon.}
}
\value{
A MULTILINESTRING sf object is returned.
}
\description{
Create a pencil layer. This function transforms a POLYGON or
MULTIPOLYGON sf object into a MULTILINESTRING one.
}
\examples{
mtq <- mf_get_mtq()
mtq_pencil <- mf_get_pencil(x = mtq, clip = FALSE)
mf_map(mtq)
mf_map(mtq_pencil, add = TRUE)
}
