% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggplot.R
\name{map_ggplot}
\alias{map_ggplot}
\title{ggplot2 mapping}
\usage{
map_ggplot(
  x,
  map = "world",
  point_color = "#86161f",
  color = NULL,
  size = 3,
  lon = "longitude",
  lat = "latitude",
  name = NULL,
  ...
)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{gbif_data}, \code{SpatialPoints},
\code{SpatialPointsDataFrame}, or \code{data.frame}. The package
\pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{map}{(character) One of world, world2, state, usa, county, france,
italy, or nz}

\item{point_color}{Default color of your points. Deprecated, use
\code{color}}

\item{color}{Default color of your points.}

\item{size}{point size, Default: 3}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess,
but if nothing close, we stop. Default: \code{longitude} and
\code{latitude}}

\item{name}{(character) the column name that contains the name to use in
creating the map. If left \code{NULL} we look for a "name" column.
default: \code{NULL}}

\item{...}{Ignored}
}
\value{
A ggplot2 map, of class \code{gg/ggplot}
}
\description{
ggplot2 mapping
}
\examples{
# map spocc output, here using a built in object
data(occdat_eg1)
map_ggplot(occdat_eg1)

# map rgbif output, here using a built in object
data(gbif_eg1)
map_ggplot(gbif_eg1)

\dontrun{
## spocc
library("spocc")
ddat <- occ(query = 'Lynx rufus californicus', from = 'gbif', limit=100)
map_ggplot(ddat)
map_ggplot(ddat$gbif)
map_ggplot(ddat$gbif, "usa")
map_ggplot(ddat, "county")

### usage of occ2sp()
#### SpatialPoints
spdat <- occ2sp(ddat)
map_ggplot(spdat)
#### SpatialPointsDataFrame
spdatdf <- as(spdat, "SpatialPointsDataFrame")
map_ggplot(spdatdf)

## rgbif
if (requireNamespace("rgbif")) {
library("rgbif")
library("ggplot2")
### occ_search() output
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_ggplot(res)

### occ_data() output
res <- occ_data(scientificName = "Puma concolor", limit = 100)
map_ggplot(res)

#### many taxa
res <- occ_data(scientificName = c("Puma concolor", "Quercus lobata"), 
   limit = 30)
map_ggplot(res)

### add a convex hull
hull(map_ggplot(res))
}

## data.frame
df <- data.frame(name = c('Poa annua', 'Puma concolor', 'Foo bar'),
                 longitude = c(-120, -121, -121),
                 latitude = c(41, 42, 45), stringsAsFactors = FALSE)
map_ggplot(df)

# many species, each gets a different color
library("spocc")
spp <- c('Danaus plexippus', 'Accipiter striatus', 'Pinus contorta')
dat <- occ(spp, from = 'gbif', limit = 30, has_coords = TRUE)
map_ggplot(dat, color = c('#976AAE', '#6B944D', '#BD5945'))
}
}
