% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggmap.R
\name{map_ggmap}
\alias{map_ggmap}
\title{ggpmap visualization of species occurences}
\usage{
map_ggmap(x, zoom = 3, point_color = "#86161f", color = NULL, size = 3,
  lon = "longitude", lat = "latitude", maptype = "terrain",
  source = "google", ...)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{SpatialPoints}, \code{SpatialPointsDataFrame}, or
\code{data.frame}. The package \pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{zoom}{zoom level for map. Adjust depending on how your data look.}

\item{point_color}{Default color of your points. Deprecated, use \code{color}}

\item{color}{Default color of your points.}

\item{size}{point size, Default: 3}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess, but
if nothing close, we stop. Default: \code{longitude} and \code{latitude}}

\item{maptype}{(character) map theme. see \code{get_map} in \code{ggmap}
for options. Default: none}

\item{source}{(character) Google Maps ("google"), OpenStreetMap ("osm"),
Stamen Maps ("stamen"), or CloudMade maps ("cloudmade"). Default: \code{osm}}

\item{...}{Ignored}
}
\description{
ggpmap visualization of species occurences
}
\details{
Does not support adding a convex hull via \code{\link{hull}}
}
\examples{
\dontrun{
## spocc
library("spocc")
gd <- occ(query = 'Accipiter striatus', from = 'gbif', limit=75,
  has_coords = TRUE)
map_ggmap(gd)
map_ggmap(gd$gbif)

## rgbif
library("rgbif")
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_ggmap(res)

## data.frame
df <- data.frame(name = c('Poa annua', 'Puma concolor', 'Foo bar'),
                 longitude = c(-120, -121, -123),
                 latitude = c(41, 42, 45), stringsAsFactors = FALSE)
map_ggmap(df)

### usage of occ2sp()
#### SpatialPointsDataFrame
spdat <- occ2sp(gd)
map_ggmap(spdat)

# many species, each gets a different color
library("spocc")
spp <- c('Danaus plexippus', 'Accipiter striatus', 'Pinus contorta')
dat <- occ(spp, from = 'gbif', limit = 30, has_coords = TRUE,
  gbifopts = list(country = 'US'))
map_ggmap(dat)
map_ggmap(dat, zoom = 5)
map_ggmap(dat, color = '#6B944D')
map_ggmap(dat, color = c('#976AAE', '#6B944D', '#BD5945'))
}
}

