% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{update_map}
\alias{update_map}
\title{Update map}
\usage{
update_map(input.maps, verbose = TRUE)
}
\arguments{
\item{input.maps}{a single map or a list of maps of class \code{mappoly.map}}

\item{verbose}{if TRUE (default), shows information about each update process}
}
\value{
an updated map (or list of maps) of class \code{mappoly.map}, containing the original map(s) plus redundant markers
}
\description{
This function takes an object of class \code{mappoly.map} and checks for
removed redundant markers in the original dataset. Once redundant markers
are found, they are re-added to the map in their respective equivalent positions
and another HMM round is performed.
}
\examples{
orig.map <- solcap.err.map
up.map <- lapply(solcap.err.map, update_map)
summary_maps(orig.map)
summary_maps(up.map)
}
\author{
Gabriel Gesteira, \email{gdesiqu@ncsu.edu}
}
