% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_map_hmm.R
\name{est_rf_hmm}
\alias{est_rf_hmm}
\alias{print.mappoly.map}
\alias{plot.mappoly.map}
\title{Multipoint analysis using Hidden Markov Models in autopolyploids}
\usage{
est_rf_hmm(
  input.seq,
  input.ph = NULL,
  thres = 0.5,
  twopt = NULL,
  verbose = FALSE,
  tol = 1e-04,
  est.given.0.rf = FALSE,
  reestimate.single.ph.configuration = TRUE,
  high.prec = TRUE
)

\method{print}{mappoly.map}(x, detailed = FALSE, ...)

\method{plot}{mappoly.map}(
  x,
  left.lim = 0,
  right.lim = Inf,
  phase = TRUE,
  mrk.names = FALSE,
  cex = 1,
  config = "best",
  P = "Parent 1",
  Q = "Parent 2",
  xlim = NULL,
  ...
)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.sequence}}

\item{input.ph}{an object of class \code{two.pts.linkage.phases}. 
If not available (default = NULL), it will be computed}

\item{thres}{LOD Score threshold used to determine if the linkage phases
compared via two-point analysis should be considered. Smaller 
values will result in smaller number of linkage phase 
configurations to be evaluated by the multipoint algorithm.}

\item{twopt}{an object of class \code{mappoly.twopt}
containing two-point information}

\item{verbose}{if \code{TRUE}, current progress is shown; if
\code{FALSE} (default), no output is produced}

\item{tol}{the desired accuracy (default = 1e-04)}

\item{est.given.0.rf}{logical. If TRUE returns a map forcing all
recombination fractions equals to 0 (1e-5, for internal use only. 
Default = FALSE)}

\item{reestimate.single.ph.configuration}{logical. If \code{TRUE}
returns a map without re-estimating the map parameters for cases
where there is only one possible linkage phase configuration. 
This argument is intended to be used in a sequential map construction}

\item{high.prec}{logical. If \code{TRUE} (default) uses high precision 
long double numbers in the HMM procedure}

\item{x}{an object of the class \code{mappoly.map}}

\item{detailed}{logical. if TRUE, prints the linkage phase configuration and the marker 
position for all maps. If FALSE (default), prints a map summary}

\item{...}{currently ignored}

\item{left.lim}{the left limit of the plot (in cM, default = 0).}

\item{right.lim}{the right limit of the plot (in cM, default = Inf, i.e., 
will print the entire map)}

\item{phase}{logical. If \code{TRUE} (default) plots the phase configuration
for both parents}

\item{mrk.names}{if TRUE, marker names are displayed (default = FALSE)}

\item{cex}{The magnification to be used for marker names}

\item{config}{should be \code{'best'} or the position of the
configuration to be plotted. If \code{'best'}, plot the configuration
with the highest likelihood}

\item{P}{a string containing the name of parent P}

\item{Q}{a string containing the name of parent Q}

\item{xlim}{range of the x-axis. If \code{xlim = NULL} (default) it uses the 
map range.}
}
\value{
A list of class \code{mappoly.map} with two elements: 

i) info:  a list containing information about the map, regardless of the linkage phase configuration:
\item{ploidy}{the ploidy level}
\item{n.mrk}{number of markers}
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{mrk.names}{the names of markers in the map}
\item{seq.dose.p1}{a vector containing the dosage in parent 1 for all markers in the map}
\item{seq.dose.p2}{a vector containing the dosage in parent 2 for all markers in the map}
\item{chrom}{a vector indicating the sequence (usually chromosome) each marker belongs 
                as informed in the input file. If not available, 
                \code{chrom = NULL}}
\item{genome.pos}{physical position (usually in megabase) of the markers into the sequence}
\item{seq.ref}{reference base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}                 
\item{seq.alt}{alternative base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}
\item{chisq.pval}{a vector containing p-values of the chi-squared test of Mendelian 
                  segregation for all markers in the map}                 
\item{data.name}{name of the dataset of class \code{mappoly.data}}
\item{ph.thres}{the LOD threshold used to define the linkage phase configurations to test}

ii) a list of maps with possible linkage phase configuration. Each map in the list is also a 
   list containing
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{seq.rf}{a vector of size (\code{n.mrk - 1}) containing a sequence of recombination 
              fraction between the adjacent markers in the map}
\item{seq.ph}{linkage phase configuration for all markers in both parents}
\item{loglike}{the hmm-based multipoint likelihood}
}
\description{
Performs the multipoint analysis proposed by \cite{Mollinari and
Garcia (2019)} in a sequence of markers
}
\details{
This function first enumerates a set of linkage phase configurations
 based on two-point recombination fraction information using a threshold
 provided by the user (argument \code{thresh}). After that, for each
 configuration, it reconstructs the genetic map using the
 HMM approach described in Mollinari and Garcia (2019). As result, it returns 
 the multipoint likelihood for each configuration in form of LOD Score comparing 
 each configuration to the most likely one. It is recommended to use a small number 
 of markers (e.g. 50 markers for hexaploids) since the possible linkage 
 phase combinations bounded only by the two-point information can be huge. 
 Also, it can be quite sensible to small changes in \code{'thresh'}. 
 For a large number of markers, please see \code{\link[mappoly]{est_rf_hmm_sequential}}.
}
\examples{
    mrk.subset <- make_seq_mappoly(hexafake, 1:10)
    red.mrk <- elim_redundant(mrk.subset)
    unique.mrks <- make_seq_mappoly(red.mrk)
    subset.pairs <- est_pairwise_rf(input.seq = unique.mrks,
                                  ncpus = 1,
                                  verbose = TRUE)

    ## Estimating subset map with a low tolerance for the E.M. procedure
    ## for CRAN testing purposes
    subset.map <- est_rf_hmm(input.seq = unique.mrks,
                             thres = 2,
                             twopt = subset.pairs,
                             verbose = TRUE,
                             tol = 0.1,
                             est.given.0.rf = FALSE)
    subset.map
    ## linkage phase configuration with highest likelihood
    plot(subset.map, mrk.names = TRUE, config = "best")
    ## the second one
    plot(subset.map, mrk.names = TRUE, config = 2)

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    https://doi.org/10.1534/g3.119.400378
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
