## ----setup,include=FALSE-------------------------------------------------

library('knitr')
library('mapmisc')
library('raster')

reRun=("reRun" %in% commandArgs(trailingOnly = TRUE))


if( Sys.info()['user'] =='patrick') {
	opts_chunk$set(dpi=72,dev.args=list(bg='white'))	
}else{	
	opts_chunk$set(dpi=36,dev.args=list(bg='white'))	
}

theNames = names(osmTiles())
africaExtent = c(15, 25)
trafalgarSquare=c(-0.128056,51.508056)

## ----downloadTiles,include=FALSE-----------------------------------------
if(reRun) {
africaTiles = openmap(africaExtent, path=theNames,zoom=2, verbose=TRUE)

londonTiles = openmap(trafalgarSquare,zoom=12,path=theNames,verbose=TRUE)

# make sure all data is stored in memory not on disk
# so that caching will work
for(D in names(africaTiles))
	values(africaTiles[[D]]) = 	values(africaTiles[[D]])
for(D in names(londonTiles))
	values(londonTiles[[D]]) = 	values(londonTiles[[D]])

if(file.exists("../inst/extdata"))
	save(africaTiles, londonTiles,
			file="../inst/extdata/tiles.RData",
			compress="xz")
} else { # don't rerun
	load(system.file("extdata", "tiles.RData", package = "mapmisc"))
}

## ----someTiles,dev='png', out.width="\\textwidth",echo=FALSE,results='asis',fig.height=5,fig.width=5----


mytiles = list(africaTiles, londonTiles)

for(D in theNames){
	Dsub = gsub("-",".", D)

	threeTiles = length(
			grep(paste("^", Dsub, 
							"([rR]ed|[gG]reen|[bB]lue)$", 
							sep=""), 
			names(mytiles[[1]]))
		)>0 | 	length(
				grep(paste("^", Dsub, 
								"([rR]ed|[gG]reen|[bB]lue)$", 
								sep=""), 
						names(mytiles[[2]]))
		)>0

	
	cat("\\section[",D,"]{{\\tt plot","RGB"[threeTiles], 
			"(openmap(x,path=\"", D, "\"))}}", sep='')
	cat("\\label{", D, "}\n",sep="")
  cat(openmapAttribution(D, 'latex'))
	cat("\n\n\\nopagebreak[4]\\begin{tabular}{ccc}\n")
	
	
	for(Dplot in 1:length(mytiles)) {
		cat("\n\\begin{minipage}{0.4\\textwidth}\n")
		cat("%", Dplot, "\n")
		oneTile = grep(paste("^", Dsub, "$", sep=""), 
				names(mytiles[[Dplot]]), value=TRUE)
		threeTiles = grep(paste("^", Dsub, 
						"([rR]ed|[gG]reen|[bB]lue)$", sep=""), 
				names(mytiles[[Dplot]]),value=TRUE)
		if(length(threeTiles)==3) {
		map.new(mytiles[[Dplot]])
			
		thetry = try(plotRGB(mytiles[[Dplot]][[
								paste(Dsub, c("Red","Green","Blue"),sep="")
								]],add=TRUE))
		if(class(thetry)=="try-error"){
			print(paste(Dsub, c("Red","Green","Blue"),sep=""))
			print(mytiles[[Dplot]][[paste(Dsub, c("Red","Green","Blue"),sep="")]])
		}
	
	
	} else if (length(oneTile)==1){
		map.new(mytiles[[Dplot]])
		try(plot(mytiles[[Dplot]][[oneTile]],add=TRUE))

	} else {

		plot.new()
		text(0.5, 0.8, paste(D, "is\n not currently\navailable"))

		
	}
	cat("\n\\end{minipage}&", #"\\begin{minipage}{0.3\\textwidth}",
			"\n")	
	}
#	cat("\n\\end{minipage}\n")
	cat("\n\\end{tabular}\n")
	
	
}


