% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_population_count.R
\name{population_count}
\alias{population_count}
\alias{calc_population_count}
\title{Calculate population count statistics}
\usage{
calc_population_count(engine = "extract", stats = "sum")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons
either one or multiple inputs as character "min", "max", "sum", "mean", "median"
"sd" or "var".}
}
\value{
A function that returns tibble with a column for population count
statistics.
}
\description{
WorldPop, which was initiated in 2013, offers easy access to spatial demographic
datasets, claiming to use peer-reviewed and fully transparent methods to create
global mosaics for the years 2000 to 2020. This function allows to efficiently
calculate population count statistics (e.g. total number of population) for
polygons. For each polygon, the desired statistic/s (min, max, sum, mean,
median, sd or var) is/are returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{worldpop}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_worldpop(years = 2000:2010)) \%>\%
  calc_indicators(
    calc_population_count(engine = "extract", stats = c("sum", "median"))
  ) \%>\%
  tidyr::unnest(population_count)

aoi
}
}
\keyword{indicator}
