% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_chirpsprec.R
\docType{data}
\name{chirpsprec}
\alias{chirpsprec}
\title{Calculate precipitation statistics based on CHIRPS}
\format{
A tibble with a column for years, months, absolute rainfall (in mm), rainfall
anomaly (in mm) and one or more columns per selected time-scale for SPI (dimensionless).
}
\description{
This functions allows to calculate precipitation statistics based on the
CHIRPS rainfall estimates. Corresponding to the time-frame of the analysis
of the portfolio, monthly precipitation statistics are calculated. These include
the total rainfall amount, rainfall anomaly against the 1981-2010 climate normal,
and the Standardized Precipitation Index (SPI) which is available for scales
between 1 and 48 months. Th function needs the \code{SPEI} package to be
installed.
The required resources for this indicator are:
\itemize{
\item \link{chirps}
}
}
\details{
The following arguments can be set:
\describe{
\item{scales_spi}{An integer vector indicating the scales for which to calculate the SPI.}
\item{spi_previous_year}{An integer specifying how many previous years to include in
order to fit the SPI. Defaults to 8 years.}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
if (Sys.getenv("NOT_CRAN") == "true") {
  library(sf)
  library(mapme.biodiversity)

  temp_loc <- file.path(tempdir(), "mapme.biodiversity")
  if (!file.exists(temp_loc)) {
    dir.create(temp_loc)
    resource_dir <- system.file("res", package = "mapme.biodiversity")
    file.copy(resource_dir, temp_loc, recursive = TRUE)
  }

  (try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
    package = "mapme.biodiversity"
  ) \%>\%
    read_sf() \%>\%
    init_portfolio(
      years = 2010,
      outdir = file.path(temp_loc, "res"),
      tmpdir = tempdir(),
      cores = 1,
      verbose = FALSE
    ) \%>\%
    get_resources("chirps") \%>\%
    calc_indicators("chirpsprec", engine = "exactextract", scales_spi = 3, spi_prev_years = 8) \%>\%
    tidyr::unnest(chirpsprec)))
}
}
\keyword{indicator}
